package com.androidbook.pettracker3;

import android.content.ContentUris;
import android.content.Context;
import android.net.Uri;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

/*  
 * Informacja: Nie używamy tej klasy w przykładzie, jednak można by zmienić PetListAdapter.getView() w następujący sposób:

			 PetListItemView i = new PetListItemView(mContext, mPets[position]);
		     return i;
		     
		     
 * Taka klasa pozwalałaby na tworzenie poszczególnych elementów listy w sposób programowy, a nie na podstawie układu 
 * zdefiniowanego w pliku XML. Takie rozwiązanie może się przydać jeśli chcemy dodawać do elementów listy 
 * przysłowiowe "wodotryski", których nie można prawidłowo skonfigurować w pliku XML.		  
 */
public class PetListItemView extends RelativeLayout {

	private final int PET_PIC_ID = 1234;
	protected TextView mPetName;
	protected TextView mPetType;
	protected ImageView mPetPic;

	public PetListItemView(Context context, PetRecord pet) {
		super(context);

		// Zdjęcie zwierzaka.
		mPetPic = new ImageView(context);
		mPetPic.setAdjustViewBounds(true);
		mPetPic.setMaxHeight(100);
		mPetPic.setMaxWidth(100);
		mPetPic.setId(PET_PIC_ID);
		if (pet.getPetImageId() != 0) {
			Uri baseUri = Uri.parse(pet.getPetImageUriPath());
			Uri imageUri = ContentUris.withAppendedId(baseUri, pet
					.getPetImageId());
			mPetPic.setImageURI(imageUri);
		}

		RelativeLayout.LayoutParams imageParams = new RelativeLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		imageParams.addRule(RelativeLayout.ALIGN_PARENT_LEFT);

		addView(mPetPic, imageParams);

		// Imię zwierzaka.
		mPetName = new TextView(context);
		mPetName.setText(pet.getPetName());

		RelativeLayout.LayoutParams nameParams = new RelativeLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		nameParams.addRule(RelativeLayout.ALIGN_RIGHT, mPetPic.getId());
		imageParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
		addView(mPetName, nameParams);

		// Gatunek zwierzaka.
		mPetType = new TextView(context);
		mPetType.setText("(" + pet.getPetType() + ")");

		RelativeLayout.LayoutParams typeParams = new RelativeLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		typeParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);

		addView(mPetType, typeParams);

	}
}
